import sys
import os
import glob
import multiprocessing
import argparse

from Cython.Build import cythonize
from Cython.Compiler import Options

Options.docstrings = False
Options.error_on_unknown_names = False
Options.error_on_uninitialized = True

directories = [
	"root/",
	"uiscript/",
	"pylib/"
]

options = {
	"cache": True,
	"force": True,
	"timestamps": True,
	"language_level": 2,
	"build_dir": "rootlib/",
	"verbose": 0,
	"errors_to_stderr": False,
}

exclude_files = [
	"test.py",
	"__teste.py",
	"mtdbg.py",
	"introtest.py",
	"consolemodule.py"
]

def run(modules, name):
	name = name.strip()
	initSource = open(options["build_dir"] + name + ".c", "w")
	initSource.write('#include <Python.h>\n')
	initSource.write('\n')
	initSource.write('struct SMethodDef\n')
	initSource.write('{\n')
	initSource.write('	char* func_name;\n')
	initSource.write('	void (*initfunc)(void);\n')
	initSource.write('};\n')
	initSource.write('\n')

	for m in modules:
		initFunction = "init%s(void)" % m
		initSource.write("void %s;\n" % initFunction)

	initSource.write('\n')
	initSource.write('static struct SMethodDef rootlib_init_methods[] =\n')
	initSource.write('{\n')

	for m in sorted(modules):
		initFunction = "init%s" % m
		initSource.write("	{ \"%s\", %s },\n" % (m, initFunction))

	initSource.write('	{ NULL, NULL },\n')
	initSource.write('};\n')
	initSource.write('\n')
	initSource.write('static PyObject* isExist(PyObject *self, PyObject *args)\n')
	initSource.write('{\n')
	initSource.write('	char* func_name;\n')
	initSource.write('\n')
	initSource.write('	if(!PyArg_ParseTuple(args, "s", &func_name))\n')
	initSource.write('		return NULL;\n')
	initSource.write('\n')
	initSource.write('	for(size_t i = 0; i < strlen(func_name); ++i)\n')
	initSource.write('		func_name[i] = (char)tolower(func_name[i]);\n')
	initSource.write('\n')
	initSource.write('	for (int i = 0; NULL != rootlib_init_methods[i].func_name;i++)\n')
	initSource.write('	{\n')
	initSource.write('		if (0 == strcmp(rootlib_init_methods[i].func_name, func_name))\n')
	initSource.write('		{\n')
	initSource.write('			return Py_BuildValue("i", 1);\n')
	initSource.write('		}\n')
	initSource.write('	}\n')
	initSource.write('	return Py_BuildValue("i", 0);\n')
	initSource.write('}\n')
	initSource.write('\n')
	initSource.write('static PyObject* moduleImport(PyObject *self, PyObject *args)\n')
	initSource.write('{\n')
	initSource.write('	char* func_name;\n')
	initSource.write('\n')
	initSource.write('	if(!PyArg_ParseTuple(args, "s", &func_name))\n')
	initSource.write('		return NULL;\n')
	initSource.write('\n')
	initSource.write('	for(size_t i = 0; i < strlen(func_name); ++i)\n')
	initSource.write('		func_name[i] = (char)tolower(func_name[i]);\n')
	initSource.write('\n')
	initSource.write('	for (int i = 0; NULL != rootlib_init_methods[i].func_name;i++)\n')
	initSource.write('	{\n')
	initSource.write('		if (0 == strcmp(rootlib_init_methods[i].func_name, func_name))\n')
	initSource.write('		{\n')
	initSource.write('			rootlib_init_methods[i].initfunc();\n')
	initSource.write('			if (PyErr_Occurred())\n')
	initSource.write('				return NULL;\n')
	initSource.write('			PyObject* m = PyDict_GetItemString(PyImport_GetModuleDict(), func_name);\n')
	initSource.write('			if (m == NULL) {\n')
	initSource.write('				PyErr_Format(PyExc_SystemError, "%s dynamic module not initialized properly", func_name);\n')
	initSource.write('				return NULL;\n')
	initSource.write('			}\n')
	initSource.write('			Py_INCREF(m);\n')
	initSource.write('			return Py_BuildValue("S", m);\n')
	initSource.write('		}\n')
	initSource.write('	}\n')
	initSource.write('	return NULL;\n')
	initSource.write('}\n')
	initSource.write('\n')
	initSource.write('void init%s()\n' % name)
	initSource.write('{\n')
	initSource.write('	static struct PyMethodDef methods[] =\n')
	initSource.write('	{\n')
	initSource.write('		{"isExist", isExist, METH_VARARGS},\n')
	initSource.write('		{"moduleImport", moduleImport, METH_VARARGS},\n')
	initSource.write('		{NULL, NULL},\n')
	initSource.write('	};\n\n')
	initSource.write('	Py_InitModule("%s", methods);\n' % name)
	initSource.write('}\n')
	return name


def main(force, verbose, warnings):
	options["force"] = force
	options["verbose"] = verbose
	options["errors_to_stderr"] = warnings

	files = []
	for dir in directories:
		for f in glob.glob(r"{0}*.py".format(dir)):
			filename = f.strip().lower()
			_, file = filename.split('\\')

			if file in exclude_files or __file__ is file:
				continue
			files.append(filename)

	threads = multiprocessing.cpu_count() / 2
	ext_modules = cythonize(files, nthreads=threads, **options)

	modules = []
	for m in ext_modules:
		if m.name == "system":
			continue

		if m.name in modules:
			raise Exception, "Module named %s already exists" % m.name

		modules.append(m.name)

	if not modules:
		return

	run(modules, "rootlib")

if __name__ == "__main__":
	parser = argparse.ArgumentParser()
	parser.add_argument('-f', '--force', action='store_true', help="Forces the recompilation of the Cython modules.")
	parser.add_argument('-v', '--verbose', action='store_true', help="Print debug information.")
	parser.add_argument('-w', '--warnings', action='store_true', help="Print warnings information.")
	args = parser.parse_args()
	main(args.force, args.verbose, args.warnings)
